% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabeta.R
\name{alpha}
\alias{alpha}
\title{Calculate Alpha Irreplaceability}
\usage{
alpha(
  local,
  global,
  target,
  df = NULL,
  alpha_col = NULL,
  triage = FALSE,
  na.allow = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{local}{number, vector or string - The feature's representation at the
site, or the name of the column containing the feature's representation at
the site.}

\item{global}{number, vector or string - The feature's globally available
representation, or the name of the column containing the feature's globally
available representation.}

\item{target}{number, vector or string - The feature's target, or the name of
the column containing the feature's target.}

\item{df}{data.frame - Optional; an input data.frame.}

\item{alpha_col}{string - The name of the column where to write alpha values.
If both df and alpha_col are provided, the output will be the input dataframe
with the additional column.}

\item{triage}{logical - Should features with unachievable targets be ignored?
Defaults to \code{FALSE}. If \code{FALSE}, these species will be always
assigned an Alpha irreplaceability of \code{1} wherever they occur. If
\code{TRUE}, these species will always be assigned an Alpha irreplaceabiltiy
of \code{0}.}

\item{na.allow}{logical - Allaw \code{NA} values in input? If \code{TRUE},
\code{NA} values in local, global or target walues will result in \code{NA}
being returned, otherwise an error will be raised. Defaults to \code{FALSE}
for single Alpha calculations, and to \code{TRUE} for calculations over
vectors or data.frames.}

\item{overwrite}{logical - Should \code{alpha_col} be overwritten if it
already exists?}
}
\value{
A number, vector or data.frame
}
\description{
This function calculates Alpha irreplaceability. Inputs can be single
parameter values needed to calculate Alpha, vectors of parameter values to
calculate a vector of Alpha values, or a \code{data.frame} with columns
containing parameters needed to calculate a vector of Alpha values.
\itemize{
  \item \strong{Single Alpha measurement:} If \code{local}, \code{global} and
  \code{target} are numeric, it calculates and returns Alpha irreplaceability.
  \item \strong{Vectorized Alpha measurement:} If \code{local}, \code{global}
  and \code{target} are vectors of the same length, a vector of Alpha
  irreplaceability values will be calculated and returned.
  \item \strong{Dataframe Alpha measurement:} If \code{df} is provided and
  \code{local}, \code{global} and \code{target} are strings representing
  field names in \code{df}, a vector of Alpha irreplaceability values will be
  caluclated and returned. \strong{Optionally:} If \code{alpha_col} is also
  provided, a \code{data.frame} identical to \code{df} will be returned with
  the calculated Alpha values in the \code{alpha_col} column.
}
}
\examples{
alpha(1, 100, 45)
alpha(c(1,25,45), c(100,100,100), c(50,50,50))
dtfrm = data.frame(
  loc = c(1,25,45),
  glob = c(100,100,100),
  targ = c(50,50,50)
)
alpha('loc', 'glob', 'targ', df = dtfrm)
}
\author{
Daniele Baisero, \email{daniele.baisero@gmail.com}
}
