% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{subset}
\alias{subset}
\alias{subset.DZdata}
\alias{subset.HMdata}
\alias{subset.default}
\title{Get a subset of a provenance dataset}
\usage{
subset(x, ...)

\method{subset}{default}(x, ...)

\method{subset}{DZdata}(x, i, ...)

\method{subset}{HMdata}(x, i, ...)
}
\arguments{
\item{x}{an object of class \code{DZdata} or \code{HMdata}}

\item{...}{optional arguments for the generic subset function}

\item{i}{the indices of the samples to be returned}
}
\value{
an object of class \code{DZdata} or \code{HMdata}
}
\description{
Return a subset of provenance data according to some specified
indices
}
\examples{
fname <- system.file("HM.csv",package="provenance")
HM <- read.HMdata(fname)
i <- match(c("N1","N2","T8","T13","N12","N13"),names(HM))
foo <- subset(HM,i)
summaryplot(foo,ncol=2)
}

