% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{read.DZdata}
\alias{read.DZdata}
\title{Read a .csv file with continuous (detrital zircon) data}
\usage{
read.DZdata(datafile, errorfile = NULL, metric = "KS",
  xlabel = "age [Ma]", colmap = "rainbow")
}
\arguments{
\item{datafile}{the path of a .csv file with the input data,
arranged in columns.}

\item{errorfile}{the (optional) path of a .csv file with the
standard errors of the input data, arranged by column in the same
order as \code{datafile}. Must be specified if the data are to be
compared with the Sircombe-Hazelton distance.}

\item{metric}{an optional string specifying the dissimilarity
measure which should be used for comparing this with other
datasets. Should be one of either \code{"KS"} (for
Kolmogorov-Smirnov) or \code{"SH"} (for Sircombe and Hazelton). If
\code{metric = "SH"}, then \code{errorfile} should be specified. If
\code{metric = "SH"} and \code{errorfile} is unspecified, then the
program will default back to the Kolmogorov-Smirnov dissimilarity.}

\item{xlabel}{an optional string specifying the nature and units of
the data.  This string is used to label kernel density estimates.}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the data.}
}
\value{
an object of class \code{DZdata}, i.e. a list with the
following items:

\code{x}: a named list of vectors containing the numerical data for each sample

\code{err}: an (optional) named list of vectors containing the standard errors of \code{x}

\code{metric}: either "KS" (for Kolmogorov-Smirnov) or "SH" (for Sircombe Hazelton)

\code{breaks}: a vector with the locations of the histogram bin edges

\code{xlabel}: a string containing the label to be given to the x-axis on all plots
}
\description{
Reads a data table containing continuous data (e.g. detrital zircon
ages)
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
DZ <- read.DZdata(fname)
plot(getKDE(DZ$x$N1))
}

