/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.stream.CorePipedInputStream;
import com.qarks.util.stream.CorePipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipperInputStream
extends InputStream {
    private boolean eof = false;
    private InputStream streamToZip;
    private CorePipedInputStream pipeIn;
    private CorePipedOutputStream pipeOut;
    private ZipOutputStream zos;
    private byte[] array;

    public ZipperInputStream(InputStream inputStream) throws IOException {
        this.streamToZip = inputStream;
        this.pipeIn = new CorePipedInputStream();
        this.pipeOut = new CorePipedOutputStream(this.pipeIn);
        this.zos = new ZipOutputStream(this.pipeOut);
        this.zos.putNextEntry(new ZipEntry("content"));
        this.array = new byte[1024];
    }

    @Override
    public int read() throws IOException {
        while (this.pipeIn.available() == 0 && !this.eof) {
            int n = this.streamToZip.read(this.array);
            if (n == -1) {
                this.eof = true;
                this.zos.closeEntry();
                continue;
            }
            this.zos.write(this.array, 0, n);
        }
        int n = this.eof && this.pipeIn.available() == 0 ? -1 : this.pipeIn.read();
        return n;
    }
}

