% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_uniprot.R
\name{fetch_uniprot}
\alias{fetch_uniprot}
\title{Fetch protein data from UniProt}
\usage{
fetch_uniprot(
  uniprot_ids,
  columns = c("protein names", "length", "sequence", "genes", "database(GeneID)",
    "database(String)", "go(molecular function)", "go(biological process)",
    "go(cellular compartment)", "interactor", "feature(ACTIVE SITE)",
    "feature(BINDING SITE)", "feature(METAL BINDING)", "chebi(Cofactor)",
    "chebi(Catalytic activity)", "database(PDB)"),
  batchsize = 200,
  show_progress = TRUE
)
}
\arguments{
\item{uniprot_ids}{a character vector of UniProt accession numbers.}

\item{columns}{a character vector of metadata columns that should be imported from UniProt (all
possible columns can be found \href{https://www.uniprot.org/help/uniprotkb_column_names}{here}.)}

\item{batchsize}{a numeric value that specifies the number of proteins processed in a single
single query. Default is 200.}

\item{show_progress}{a logical value that determines if a progress bar will be shown. Default
is TRUE.}
}
\value{
A data frame that contains all protein metadata specified in \code{columns} for the
proteins provided. If an invalid ID was provided that contains a valid UniProt ID, the valid
portion of the ID is fetched and the invalid input ID is saved in a column called \code{input_id}.
}
\description{
Fetches protein metadata from UniProt.
}
\examples{
\donttest{
fetch_uniprot(c("P36578", "O43324", "Q00796"))
}
}
