% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median_normalisation.R
\name{median_normalisation}
\alias{median_normalisation}
\title{Median normalisation}
\usage{
median_normalisation(data, sample, intensity_log2)
}
\arguments{
\item{data}{A data frame containing at least sample names and intensity values.}

\item{sample}{The name of the column containing the sample names.}

\item{intensity_log2}{The name of the column containing the log2 transformed intensity values to be normalised.}
}
\value{
A dataframe with a column called \code{normalised_intensity_log2} containing the normalised intensity values.
}
\description{
Performs median normalisation on intensities. The normalised intensity is the original intensity minus the run median plus the global median. This is also the way it is implemented in Spectronaut.
}
\examples{
data <- data.frame(
  r_file_name = c("s1", "s2", "s3", "s1", "s2", "s3"),
  intensity_log2 = c(18, 19, 17, 20, 21, 19)
)

median_normalisation(data,
  sample = r_file_name,
  intensity_log2 = intensity_log2
)
}
