% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\name{insertSamples}
\alias{insertSamples}
\title{Insert sample on a given position}
\usage{
insertSamples(
  S,
  stdName = "autoQC01",
  stdPosX = "8",
  stdPosY = "F",
  plate = 1,
  volume = 2,
  method = "",
  ...
)
}
\arguments{
\item{S}{input \code{data.frame}}

\item{stdName}{name of the sample}

\item{stdPosX}{x location on the plate}

\item{stdPosY}{y location on the plate}

\item{plate}{number of the plate}

\item{volume}{injection volume}

\item{method}{a path to the method file (optional)}

\item{...}{addition parameter, e.g.,  \code{howoften = 1} \code{howmany = 1}.}
}
\value{
\code{data.frame}
}
\description{
Insert sample on a given position
}
\examples{
iris[c(1:15,51:65,101:115), ] |>
  assignPlatePosition() |>
  insertSamples(howoften=4, begin=FALSE, end=FALSE,
    stdPosX='6', stdPosY='F', plate=1, stdName = "clean")
    
}
