% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisor.R
\name{divisor_methods}
\alias{divisor_methods}
\alias{divisor_round}
\alias{divisor_floor}
\alias{divisor_harmonic}
\alias{divisor_geometric}
\alias{divisor_ceiling}
\title{Divisor methods}
\usage{
divisor_round(votes, n_seats, quorum = 0)

divisor_floor(votes, n_seats, quorum = 0)

divisor_harmonic(votes, n_seats, quorum = 0)

divisor_geometric(votes, n_seats, quorum = 0)

divisor_ceiling(votes, n_seats, quorum = 0)
}
\arguments{
\item{votes}{numeric vector with number of votes for each party}

\item{n_seats}{total number of seats}

\item{quorum}{Vote threshold a party must reach. Used as quota of total
votes within a district if less than 1 otherwise as number
of votes.}
}
\value{
The number of seats per party as a vector
}
\description{
Functions to directly apply divisor apportionment methods instead
of calling \code{\link[=proporz]{proporz()}} with a method parameter.
}
\details{
Divisor methods are known under different names:
\itemize{
\item{d'hondt, jefferson, hagenbach-bischoff: use \code{\link[=divisor_floor]{divisor_floor()}}}
\item{sainte-lague, webster: use \code{\link[=divisor_round]{divisor_round()}}}
\item{adams: use \code{\link[=divisor_ceiling]{divisor_ceiling()}}}
\item{dean: use \code{\link[=divisor_harmonic]{divisor_harmonic()}}}
\item{huntington-hill, hill-huntington: use \code{\link[=divisor_geometric]{divisor_geometric()}}}
}

All divisor functions call \code{\link[=highest_averages_method]{highest_averages_method()}} with a different sequence of
divisors.
}
\examples{
votes = c("Party A" = 690, "Party B" = 400,
          "Party C" = 250, "Party D" = 120)

divisor_round(votes, 10)

divisor_floor(votes, 10)

divisor_ceiling(votes, 10)

divisor_ceiling(votes, 5)

divisor_geometric(votes, 10, quorum = 0.05)

divisor_harmonic(votes, 10)
}
\seealso{
\code{\link[=proporz]{proporz()}}
}
