% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{header}
\alias{header}
\title{Print project header to console}
\usage{
header(project, archived = FALSE)
}
\arguments{
\item{project}{Project \code{id} or unambiguous substring of the project name
from the \code{\link{projects}()} table.}

\item{archived}{Logical, indicating whether or not the function should
  consider archived projects when determining which project the user is
  referring to in the \code{project} argument. \code{FALSE} by default.

  See the \strong{Details} section of \code{\link{archive_project}()} for
  more information on the "archived" status of a project.}
}
\description{
Prints a header to the console to be copied and pasted into the YAML of a
project protocol or manuscript R Markdown file. These lines essentially
produce a title page when the R Markdown file is knitted.
}
\details{
The project header consists of:

\enumerate{

\item the project title

\item the author list

\item the list of author affiliations

\item corresponding author information

}
}
\examples{
#############################################################################
# SETUP
old_home <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
Sys.setenv(HOME = temp_dir)
setup_projects(path = temp_dir)
new_affiliation(department_name = "Math Dept.",
                institution_name = "Springfield College",
                address = "123 College St, Springfield, AB")
new_affiliation(department_name = "Art Department",
                institution_name = "Springfield College",
                address = "321 University Boulevard, Springfield, AB",
                id = 42)
new_affiliation(department_name = "Central Intelligence Agency",
                institution_name = "United States Government",
                address = "888 Classified Dr, Washington DC")
new_affiliation(department_name = "Pyrotechnics",
                institution_name = "ACME")
new_author(given_names = "Rosetta", last_name = "Stone",
           affiliations = c(42, "Math"), degree = "PhD",
           email = "slab@rock.net", phone = "867-555-5309", id = 8888)
new_author(given_names = "Spiro", last_name = "Agnew", degree = "LLB",
           affiliations = "Art D", id = 13)
new_author(given_names = "Plato", id = 303)
new_project(title = "Test Project 1", authors = c(13, "303", "Stone"),
            corresp_auth = "Stone")
#############################################################################

header(1)

#############################################################################
# CLEANUP
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
