% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-projects_author.R
\name{projects_author}
\alias{projects_author}
\alias{new_projects_author}
\alias{as.integer.projects_author}
\alias{as.double.projects_author}
\alias{as.numeric.projects_author}
\alias{match.projects_author}
\alias{\%in\%.projects_author}
\title{\code{projects_author} class and its methods}
\usage{
new_projects_author(x = character())

\method{as.integer}{projects_author}(x, ...)

\method{as.double}{projects_author}(x, ...)

\method{as.numeric}{projects_author}(x, ...)

\method{match}{projects_author}(x, table, nomatch = NA_integer_,
  incomparables = NULL)

\method{\%in\%}{projects_author}(x, table)
}
\arguments{
\item{x}{For \code{new_projects_author()}, any object. For

  For the \code{as.*()} methods, a \code{projects_author} object.

  For \code{\link{match}()} and \code{\link{\%in\%}}, an integer, a character
  string, or a \code{projects_author} object. See \code{\link{match}()} and
  \strong{Equality and value matching methods} below.}

\item{...}{further arguments passed to or from other methods.}

\item{table}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()}  and
\strong{Equality and value matching methods} below.}

\item{nomatch}{See \code{\link{match}()}.}

\item{incomparables}{An integer number, a character string, or a
\code{projects_author} object. See \code{\link{match}()}.}
}
\description{
Objects of this class contain both the \code{id} and the \code{last_name} of
an author so that the package and the user, respectively, can easily identify
the author.
}
\details{
Essentially, this is a character string of the form:

\code{id: last_name}

\code{new_projects_author()} merely coerces the object's class attribute to
\code{projects_author}.
}
\section{Numeric coercion methods}{
 \code{\link{as.integer}()},
  \code{\link{as.double}()}, and \code{\link{as.numeric}()} return the
  \code{id} portion of the \code{projects_author} object as an
  integer/double. The methods for the equality and value matching functions
  described below make use of these numeric coercion methods. Users desiring
  to apply value matching functions other than the ones described below may
  similarly take advantage of these.
}

\section{Equality and value matching methods}{
 Methods for \code{\link{==}},
  \code{\link{!=}}, \code{\link{match}()}, and \code{\link{\%in\%}} enable
  users to test equality and to value match among \code{projects_author}
  objects and as well as between \code{projects_author} objects and unclassed
  numbers/characters. When testing or matching against a numeric vector, the
  \code{projects_author} object is first coerced to an integer with the
  \code{as.integer()} method described above. When testing or matching
  against a character vector, the character vector is validated against the
  \code{\link{authors}()} table.
}

\section{\code{c()} method}{
 A method for \code{\link{c}()} was also written
  so that the class attribute is not lost.
}

\examples{
jones <- new_projects_author("33: Jones")

as.integer(jones) # 33

jones == 33       # TRUE
jones == 10       # FALSE
jones != 33       # FALSE

jones \%in\% c(20:40)     # TRUE
match(jones, c(31:40))  # 3

\dontrun{
# Not run because no authors() table is created within this example code.
jones == "jOnES"
# TRUE, assuming that the authors() table contains an author with an id of 3
# and a last_name beginning with "jones" (not case sensitive).
}

x <- structure("32: Clinton", class = "dummyclass")
class(c(x))     # Does not retain class
class(c(jones)) # Retains class
}
\seealso{
\code{\link{Ops}}; \code{\link[methods]{Methods_for_Nongenerics}}.
  For other S3 class-retention strategies, see \code{\link{Extract}} and
  \code{\link{[.data.frame}}.
}
