% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_theme}
\alias{set_theme}
\alias{unset_theme}
\title{Change default plotting behavior}
\usage{
set_theme(pal_name = "blue-red", pal_name_discrete = "discrete", exact = NULL)

unset_theme()
}
\arguments{
\item{pal_name}{Profinit palette name to be used. Defaults to \code{blue-red}.}

\item{pal_name_discrete}{(Optional). Palette name for discrete color scales to be used by \code{ggplot}. Defaults to \code{discrete}.}

\item{exact}{Indicates whether discrete values will be treated exactly as present in the palette OR
whether and interpolation can take a place.}
}
\value{
The function returns nothing, it edits default behavior. Recent default configs are stored in a backup option.

The function returns nothing, it just changes default behaviour.
}
\description{
This function alternates the default graphics behavior (both, base R graphics
and ggplot2 graphics) to follow Profinit visual guide.
Be were, the recent setup is not stored anywhere before changing the values.

The function sets to defaults color and fill scales in ggplot2, R4 color
palette (base graphics) and greyish color theme in ggplot2.
}
\section{Functions}{
\itemize{
\item \code{set_theme()}: Sets default plotting theme to Profinit.

\item \code{unset_theme()}: Resets default plotting theme.

}}
\examples{
# Example 1 - BaseR

# As a starting point, there is a plot i base R graphic:
sample_df <- data.frame(x=1:8, y=1:8, category=as.character(1:8), col_cont = 1:8)
barplot(sample_df$y, col=sample_df$category)

# Now, by applying hte set_theme() we can change the default behavior:
profiplots::set_theme("blue-red", "blue-red")
barplot(sample_df$y, col=sample_df$category)

# To turn the theming off, just call:
profiplots::unset_theme()

# Example 2 - GGplot
library("ggplot2")
plot_gg <- ggplot(sample_df, aes(x=x, y=y, fill=category)) + stat_identity(geom="bar")
plot_gg

# Now, let's trun it into Profinit graphics.
profiplots::set_theme("blue-red", "blue-red")
plot_gg

# To remove the Profinit theme from defaults, just call:
profiplots::unset_theme()


}
