% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{profinit_pal}
\alias{profinit_pal}
\title{Profinit color palettes}
\usage{
profinit_pal(pal_name = "blue-red", reverse = FALSE, exact = NULL, ...)
}
\arguments{
\item{pal_name}{Character name of chosen Profinit palette. See \code{profinit_pal.pals()} for available palettes.}

\item{reverse}{Boolean indicating whether the palette should be reversed}

\item{exact}{Indicates whether the color scale is supposed to be followed exactly.
Be ware you may run out of colors. Defaults to \code{TRUE} for discrete palette names, \code{FALSE} otherwise.}

\item{...}{Additional arguments to pass to \code{grDevices::colorRampPalette()}}
}
\value{
A function providing desired number of colors (hex codes) from the specified palette.
}
\description{
Returns function that interpolates (if \code{exact=FALSE}) chosen Profinit color palette.
That is, the resulting function is able to give you desired number
of colors (hexes) within given Profinit color palette.
}
\details{
See the examples for more details about its usecase.
}
\examples{
# Example 1 - get colors from the 'discrete' Profinit palette
discrete_cols <- profinit_pal("discrete")
discrete_cols(3)
scales::show_col(discrete_cols(3))

# .. The number of colors is limited in this palette. Once you reach the
# limit, Profinit's grey is used to fill the missings:
scales::show_col(discrete_cols(10))

# .. You can bypass this via either enabling the interpolation (defaults
# to `FALSE` for `discrete`-like color palettes and `TRUE` for other palettes)
# or try your luck with full set of Profinit colors.
discrete_cols_int <- profinit_pal("discrete", exact = FALSE)
scales::show_col(discrete_cols_int(10))


# Example 2 - get colors from other Profinit palette
profinit_reds_cols <- profinit_pal("reds")
profinit_reds_cols(3)
scales::show_col(profinit_reds_cols(3))
# Again, we can interpolate
profinit_reds_cols(15)
scales::show_col(profinit_reds_cols(15))

# Example 3 - using palette in baseR plots
plot(mtcars$mpg, mtcars$qsec, col=profinit_pal("discrete")(5), pch=16)

}
