% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodigen.R
\name{prodigen}
\alias{prodigen}
\title{Create a project directory based on a template.}
\usage{
prodigen(type, name = NULL, path = getwd(), git.init = FALSE)
}
\arguments{
\item{type}{type of project to create, based on the templates found in
\code{\link[prodigenr]{template_list}} function}

\item{name}{name of the new project directory}

\item{path}{location of where the new project will be created}

\item{git.init}{Logical, whether to initialize the new project with git}
}
\value{
Creates a project directory with files and subdirectories
}
\description{
Create a project directory and associated files. Is based on using RStudio
and the \link[devtools]{devtools} package development way of working with
files and code. So commands/keybindings like
\code{\link[devtools]{load_all}} (Ctrl-Shift-L) and
\code{\link[devtools]{document}} (Ctrl-Shift-D) work to update your code and
allow an continuous and integrated approach to analyzing your data and
writing up your research product.
}
\examples{

\dontrun{\donttest{
# Get a list of possible project templates
template_list
# Create a project. Best done in a fresh R console.
prodigen('poster', 'poster', 'dev/', TRUE, FALSE)
prodigen('poster', 'poster', 'path/to/dir/', FALSE)
prodigen('poster', 'posterName', git.init = FALSE)
prodigen('abstract', 'name', './', FALSE)
prodigen('manuscript', path = './', git.init = TRUE)
}}
}

