% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSummary3.R
\name{modSummary3}
\alias{modSummary3}
\title{Summary of moderation effect}
\usage{
modSummary3(
  fit,
  X = NULL,
  W = NULL,
  Z = NULL,
  labels = NULL,
  modx.values = NULL,
  mod2.values = NULL,
  rangemode = 2,
  maxylev = 6,
  digits = 3
)
}
\arguments{
\item{fit}{An object of class lm}

\item{X}{Name of independent variable}

\item{W}{Name of the first moderator variable}

\item{Z}{Name of the second moderator variable}

\item{labels}{Optional list of variable names}

\item{modx.values}{Values of moderator variable}

\item{mod2.values}{Values of the second moderator variable}

\item{rangemode}{Integer. 1 or 2.}

\item{maxylev}{maximum unique length of variable to be treated as a categorical variable}

\item{digits}{integer indicating the number of decimal places}
}
\description{
Summary of moderation effect
}
\examples{
fit=lm(govact~negemot*sex+negemot*age+posemot+ideology,data=glbwarm)
modSummary3(fit,mod2.values=c(30,50,70))
fit1=lm(govact~negemot*sex*age+posemot+ideology,data=glbwarm)
modSummary3(fit1,rangemode=1)
fit=lm(mpg~hp*wt,data=mtcars)
modSummary3(fit)
}
