% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_features.R
\name{number_of_features}
\alias{number_of_features}
\alias{number_of_features.ConservationProblem}
\alias{number_of_features.OptimizationProblem}
\alias{number_of_features.ZonesSpatRaster}
\alias{number_of_features.ZonesRaster}
\alias{number_of_features.ZonesCharacter}
\title{Number of features}
\usage{
number_of_features(x, ...)

\method{number_of_features}{ConservationProblem}(x, ...)

\method{number_of_features}{OptimizationProblem}(x, ...)

\method{number_of_features}{ZonesSpatRaster}(x, ...)

\method{number_of_features}{ZonesRaster}(x, ...)

\method{number_of_features}{ZonesCharacter}(x, ...)
}
\arguments{
\item{x}{A \code{\link[=problem]{problem()}}, \code{\link[=optimization_problem]{optimization_problem()}}, or \code{\link[=zones]{zones()}} object.}

\item{...}{not used.}
}
\value{
An \code{integer} number of features.
}
\description{
Extract the number of features in an object.
}
\examples{
\dontrun{
# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()

# create problem
p <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.2) \%>\%
  add_binary_decisions()

# print number of features
print(number_of_features(p))
}
}
