% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistdoublecens.R
\name{.dpcens}
\alias{.dpcens}
\title{Define a fitdistrplus compatible wrapper around dprimarycensored}
\usage{
.dpcens(x, params, pdist, dprimary, dprimary_args, ...)
}
\arguments{
\item{x}{Vector of quantiles}

\item{params}{A data frame with columns 'swindow', 'pwindow', and 'D'
corresponding to the secondary window sizes, primary window sizes, and
truncation times for each element in x.}

\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{\link[=pcd_primary_distributions]{pcd_primary_distributions()}} for examples. The package can identify
base R distributions for potential analytical solutions. For non-base R
functions, users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{...}{Additional arguments to be passed to the distribution function}
}
\description{
Define a fitdistrplus compatible wrapper around dprimarycensored
}
\keyword{internal}
