% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.format_class}
\alias{.format_class}
\title{Extract and Combine Distribution Names}
\usage{
.format_class(pdist, dprimary)
}
\arguments{
\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples. The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}
}
\value{
a character string representing the combined distribution class
}
\description{
This helper function attempts to determine distribution names and uses those
to establish a class name for potential analytical solutions.
}
\keyword{internal}
