% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistdoublecens.R
\name{.ppcens}
\alias{.ppcens}
\title{Define a fitdistrplus compatible wrapper around pprimarycensored}
\usage{
.ppcens(
  q,
  pdist,
  pwindow,
  D,
  dprimary,
  dprimary_args,
  pdist_name,
  dprimary_name,
  ...
)
}
\arguments{
\item{q}{Vector of quantiles}

\item{pdist}{Distribution function (CDF)}

\item{pwindow}{Primary event window}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{pdist_name}{A string specifying the name of the delay distribution
function. If NULL, the function name is extracted using
\code{\link[=.extract_function_name]{.extract_function_name()}}. Used to determine if a analytical solution
exists for the primary censored distribution. Must be set if \code{pdist} is
passed a pre-assigned variable rather than a function name.}

\item{dprimary_name}{A string specifying the name of the primary event
distribution function. If NULL, the function name is extracted using
\code{\link[=.extract_function_name]{.extract_function_name()}}. Used to determine if a analytical solution
exists for the primary censored distribution. Must be set if \code{dprimary} is
passed a pre-assigned variable rather than a function name.}

\item{...}{Additional arguments to be passed to pdist}
}
\description{
Define a fitdistrplus compatible wrapper around pprimarycensored
}
\keyword{internal}
