% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationfunctions.R
\name{length_biased_dist}
\alias{length_biased_dist}
\title{Calculate length-biased distribution from discrete length-unbiased distribution
starting at 1}
\usage{
length_biased_dist(dist)
}
\arguments{
\item{dist}{vector of probabilities of distribution to transform}
}
\value{
vector of probabilities of transformed distribution
}
\description{
Calculate length-biased distribution from discrete length-unbiased distribution
starting at 1
}
\examples{

# geometric distribution starting in 1 and cutoff at 70 with mean at about 8.
geom.dist <- create_dist_vec(geom_dist_fct, max.dist = 70)
# calculate mean
sum(1:length(geom.dist)*geom.dist)
# plot original distribution
plot(geom.dist)
geom.dist.lb <- length_biased_dist(geom.dist)
# plot length biased distribution
plot(geom.dist.lb)

}
