% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{automask}
\alias{automask}
\title{automask footprint}
\usage{
automask(pressure_data, foot_side = "auto", mask_scheme, plot = FALSE)
}
\arguments{
\item{pressure_data}{List. First item is a 3D array covering each timepoint
of the measurement. z dimension represents time}

\item{foot_side}{String. "RIGHT", "LEFT", or "auto". Auto uses
auto_detect_side function}

\item{mask_scheme}{String.}

\item{plot}{Logical. Whether to play the animation}
}
\value{
List. Masks are added to pressure data variable
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
 }
}
\description{
Automatically creates mask of footprint data
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- automask(pressure_data, foot_side = "auto", plot = TRUE)
}
