% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{c2_dat1}
\alias{c2_dat1}
\title{Cross-classified data (example 1)}
\format{
A \code{data.frame} with 27 rows and 3 columns:
\describe{
  \item{y_ijk}{observations}
  \item{a}{treatment a}
  \item{b}{treatment b}
}
}
\usage{
c2_dat1
}
\description{
c2_dat1 contains data that is sampled from a balanced cross-classified design.
}
\examples{
# loading lme4
library(lme4)

# Fitting a random effects model based on c2_dat_1
fit <- lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)
summary(fit)

# Upper prediction limit for m=3 future observations
\donttest{pred_int <- lmer_pi_unstruc(model=fit, m=3, alternative="upper", nboot=100)
summary(pred_int)}

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
