% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dummy_vars}
\alias{dummy_vars}
\title{Create dummy variables for all categorical/factor variables in a data.frame}
\usage{
dummy_vars(df)
}
\arguments{
\item{df}{a data.frame on which to make dummy variables for each
categorical/factor variable, based on contrasts.}
}
\value{
a data.frame matching \code{df} but where each categorical
variable in \code{df} is replaced with indicator variables. All
combinations of the indicator/dummy variable are returned. Naming
convention of the new dummy variables is variable_level. For example, a
factor variable in \code{df} named "colour" with levels "red", "green" and
"purple" will be replaced with three columns (the new dummy variables),
named colour_red,  colour_green and colour_purple.
}
\description{
Create dummy/indicator variables for all categorical variables in a
data.frame. Can be used as a pre-processing step before calling other
functions within the package.
}
\examples{
dummy_vars(data.frame("Colour" = factor(sample(c("red",
                                                 "azure",
                                                 "green",
                                                 "white"),
                                              500,
                                              replace = TRUE))))
}
\seealso{
\code{\link{pred_input_info}}
}
