% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_surv.R
\name{scoresurv}
\alias{scoresurv}
\title{Calculate the log CATE score given the baseline covariates and follow-up time for specified scoring method methods for survival outcomes}
\usage{
scoresurv(
  fit,
  x.cate,
  tau0,
  score.method = c("randomForest", "boosting", "poisson", "twoReg", "contrastReg")
)
}
\arguments{
\item{fit}{List of objects generated from intxsurv: outputs of random forest, boosting, naive Poisson, two regression, contrast regression}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates specified in the outcome model; dimension \code{n} by \code{p.cate}.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{score.method}{A vector of one or multiple methods to estimate the CATE score.
Allowed values are: \code{'randomForest'}, \code{'boosting'}, \code{'poisson'}, \code{'twoReg'},
\code{'contrastReg'}. Default specifies all 5 methods.}
}
\value{
score.randomForest: Estimated log CATE score for all \code{n} observations with the random forest method; vector of size \code{n}
        score.boosting: Estimated log CATE score for all \code{n} observations with the boosting method; vector of size \code{n}
        score.poisson: Estimated log CATE score for all \code{n} observations with the naive Poisson method; vector of size \code{n}
        score.twoReg: Estimated log CATE score for all \code{n} observations with the two regression method; vector of size \code{n}
        score.contrastReg: Estimated log CATE score for all \code{n} observations with the contrast regression method; vector of size \code{n}
        score = NA if the corresponding method is not called
}
\description{
Based on intxsurv results of the CATE coefficients estimated with random forest, boosting, naive Poisson, two regression, contrast regression
}
