% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upper_limit.R
\name{upper_risk_difference}
\alias{upper_risk_difference}
\alias{upper_risk_ratio}
\alias{upper_rate_difference}
\alias{upper_rate_ratio}
\alias{upper_odds_ratio}
\title{Estimate sample size based on probability that upper limit is below level of
concern.}
\usage{
upper_risk_difference(
  upper_limit,
  prob,
  exposed,
  unexposed,
  group_ratio,
  ci = 0.95
)

upper_risk_ratio(upper_limit, prob, exposed, unexposed, group_ratio, ci = 0.95)

upper_rate_difference(
  upper_limit,
  prob,
  exposed,
  unexposed,
  group_ratio,
  ci = 0.95
)

upper_rate_ratio(upper_limit, prob, exposed, unexposed, group_ratio, ci = 0.95)

upper_odds_ratio(
  upper_limit,
  prob,
  exposed_cases,
  exposed_controls,
  group_ratio,
  ci = 0.95
)
}
\arguments{
\item{upper_limit}{The upper limit of the confidence interval, a level of
concern.}

\item{prob}{The probability of the estimated upper limit of the confidence
interval being at or below the level of concern.}

\item{exposed}{The risk or rate among the exposed cohort.}

\item{unexposed}{The risk or rate among the unexposed cohort.}

\item{group_ratio}{In cohort studies, the ratio of the unexposed to the
exposed. In case-control studies, the ratio of the controls to the cases.}

\item{ci}{The confidence interval as a probability or percent. Default is
.95.}

\item{exposed_cases}{The proportion of exposed cases.}

\item{exposed_controls}{The proportion of exposed controls.}
}
\value{
a tibble with sample size, effect measure, upper limit, and
probability
}
\description{
These functions calculate sample size based on probability that upper limit
is below level of concern. The idea behind this approach is to use precision
to provide support for the absence of effect. These functions calculate
sample size where, when the true effect is null, the upper limit of the
confidence interval of the estimate of interest has a probability of being at
or under a specified level of concern.
}
\examples{

# From Rothman and Greenland 2018

upper_rate_ratio(
  upper_limit = 2,
  prob = .90,
  exposed = .01,
  unexposed = .01,
  group_ratio = 1
)

}
\references{
Rothman, K.J. and Greenland, S. 2018.
\href{https://pubmed.ncbi.nlm.nih.gov/29912015/}{Planning Study Size Based on Precision Rather Than Power}. 29(5):599-603.
}
