% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxicity_generators.R
\docType{class}
\name{hyper_mtdi_lognormal-class}
\alias{hyper_mtdi_lognormal-class}
\alias{hyper_mtdi_lognormal}
\title{Hyperprior for lognormal MTDi distributions}
\description{
This hyperprior generates lognormal MTDi distributions with their
coefficients of variation being drawn from a Rayleigh distribution
with mode parameter set to
\deqn{\sigma := CV.}
Because the standard deviation of this distribution is
\deqn{sd = \sigma \sqrt{(2 - \pi/2)} \approx 0.655 \sigma,}{%
       sd = \sigma \sqrt(2 - \pi/2) ~ 0.655 \sigma,}
this conveniently links our uncertainty about \code{CV} to its \emph{mode},
and indeed to other measures of centrality that are proportional to this:
\deqn{mean = \sigma \sqrt{\pi/2} \approx 1.25 \sigma}{%
       mean = \sigma \sqrt(\pi/2) ~ 1.25 \sigma}

\deqn{median = \sigma \sqrt{2 log(2)} \approx 1.18 \sigma.}{%
       median = \sigma \sqrt(2 log(2)) ~ 1.18 \sigma.}
The \emph{medians} of the lognormal distributions generated are themselves
drawn from a lognormal distribution with \code{meanlog = log(median_mtd)}
and \code{sdlog = median_sdlog}. Thus, parameter \code{median_sdlog}
represents a proportional uncertainty in \code{median_mtd}.
}
\section{Slots}{

\describe{
\item{\code{CV}}{Coefficient of variation}

\item{\code{median_mtd}}{Median MTDi}

\item{\code{median_sdlog}}{Proportional uncertainty in median MTDi}
}}

