% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_zzz.R
\docType{class}
\name{ToolAUCCalculator}
\alias{ToolAUCCalculator}
\title{ToolAUCCalculator}
\format{
An \code{R6} class object.
}
\description{
\code{R6} class of the AUCCalculator tool
}
\details{
\code{ToolAUCCalculator} is a wrapper class for
the \href{http://mark.goadrich.com/programs/AUC/}{AUCCalculator} tool, which
is a Java library that provides calculations of ROC and Precision-Recall
curves.
}
\examples{
## Initialization
toolauccalc <- ToolAUCCalculator$new()

## Show object info
toolauccalc

## create_toolset should be used for benchmarking and curve evaluation
toolauccalc2 <- create_toolset("AUCCalculator")

}
\seealso{
This class is derived from \code{\link{ToolIFBase}}.
   \code{\link{create_toolset}} for creating a list of tools.
}
\section{Super class}{
\code{\link[prcbench:ToolIFBase]{prcbench::ToolIFBase}} -> \code{ToolAUCCalculator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ToolAUCCalculator-new}{\code{ToolAUCCalculator$new()}}
\item \href{#method-ToolAUCCalculator-set_jarpath}{\code{ToolAUCCalculator$set_jarpath()}}
\item \href{#method-ToolAUCCalculator-set_curvetype}{\code{ToolAUCCalculator$set_curvetype()}}
\item \href{#method-ToolAUCCalculator-set_auctype}{\code{ToolAUCCalculator$set_auctype()}}
\item \href{#method-ToolAUCCalculator-clone}{\code{ToolAUCCalculator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="call"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-call'><code>prcbench::ToolIFBase$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_auc"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_auc'><code>prcbench::ToolIFBase$get_auc()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_result"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_result'><code>prcbench::ToolIFBase$get_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_setname"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_setname'><code>prcbench::ToolIFBase$get_setname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_toolname"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_toolname'><code>prcbench::ToolIFBase$get_toolname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_x"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_x'><code>prcbench::ToolIFBase$get_x()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="get_y"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-get_y'><code>prcbench::ToolIFBase$get_y()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="print"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-print'><code>prcbench::ToolIFBase$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="set_setname"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-set_setname'><code>prcbench::ToolIFBase$set_setname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prcbench" data-topic="ToolIFBase" data-id="set_toolname"><a href='../../prcbench/html/ToolIFBase.html#method-ToolIFBase-set_toolname'><code>prcbench::ToolIFBase$set_toolname()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolAUCCalculator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ToolAUCCalculator-new}{}}}
\subsection{Method \code{new()}}{
Default class initialization method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolAUCCalculator$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{set value for \code{jarpath}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolAUCCalculator-set_jarpath"></a>}}
\if{latex}{\out{\hypertarget{method-ToolAUCCalculator-set_jarpath}{}}}
\subsection{Method \code{set_jarpath()}}{
It sets an AUCCalculator jar file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolAUCCalculator$set_jarpath(jarpath = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jarpath}}{File path of the AUCCalculator jar file,
e.g. \code{"/path1/path2/auc2.jar"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolAUCCalculator-set_curvetype"></a>}}
\if{latex}{\out{\hypertarget{method-ToolAUCCalculator-set_curvetype}{}}}
\subsection{Method \code{set_curvetype()}}{
It sets the type of curve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolAUCCalculator$set_curvetype(curvetype = "SPR")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{curvetype}}{"SPR", "PR", or "ROC"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolAUCCalculator-set_auctype"></a>}}
\if{latex}{\out{\hypertarget{method-ToolAUCCalculator-set_auctype}{}}}
\subsection{Method \code{set_auctype()}}{
It sets the type of calculation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolAUCCalculator$set_auctype(auctype)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{auctype}}{"java" or "r"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolAUCCalculator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ToolAUCCalculator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolAUCCalculator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
