% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_stylize.R
\name{tg_stylize}
\alias{tg_stylize}
\title{Convert Praat font styles to R font styles}
\usage{
tg_stylize(lab)
}
\arguments{
\item{lab}{A string or vector of strings with labels from a TextGrid.}
}
\value{
A list with elements of class \code{expression}.
}
\description{
Helper function for converting Praat font styles such as italics, bold,
and small caps into expressions that can be read by base R plots.
Instead of using
this function directly, just use
\code{praatpicture('my_sound_file', frames='TextGrid', tg_specialChar=TRUE)}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')

# With stylized text
praatpicture(soundFile, frames='TextGrid')

# Without stylized text
praatpicture(soundFile, frames='TextGrid', tg_specialChar=FALSE)
}
