\name{ppm.dat}
\alias{ppm.dat}
\title{Prepare data for model fitting}
\description{This function prepares the data for model fitting. In particular, it
determines observation weights and sets up the design matrix required for fitting
a regularisation path.}
\usage{
ppm.dat(sp.xy, sp.scale, back.xy, coord = c("X", "Y"), 
sp.dat = env.var(sp.xy = sp.xy, env.scale = sp.scale, 
env.grid = back.xy, coord = coord, file.name = "SpEnvData"),
sp.file = NA, quad.file = NA, file.name = NA)
}
\arguments{
  \item{sp.xy}{A matrix of species locations containing at least one column representing
longitude and one column representing latitude.}
  \item{sp.scale}{The spatial resolution at which to sample quadrature points.}
  \item{back.xy}{The geo-referenced matrix of environmental grids.}
  \item{coord}{A vector containing the names of the longitude and latitude coordinates, as
in \code{\link{sample.quad}}.}
  \item{sp.dat}{A matrix of species presence locations and the corresponding environmental
data, as generated by \code{\link{env.var}}.}
  \item{sp.file}{The name of a saved file containing a matrix of species presence locations 
and the corresponding environmental data, as generated by \code{\link{env.var}}.}
  \item{quad.file}{The name of a fie containing the quadrature points created from the
\code{\link{sample.quad}} function.}
  \item{file.name}{An optional argument containing the name of the saved file.}
}
\details{This function will call the \code{\link{sample.quad}} and \code{\link{env.var}}
functions to generate a quadrature scheme and interpolate environmental data to presence
locations. Alternatively, the quadrature scheme may be directly supplied to the
\code{quad.file} argument, and the matrix of presence locations and associated environmental
data may be directly supplied to either the \code{sp.dat} function (as an object in the
workspace) or to the \code{sp.file} argument (as the name of a saved file containing this
matrix).}
\value{A matrix \code{dat.ppm} with columns representing the latitude and longitude of presence
locations and quadrature points along with the associated environmental data, as well as
a column \code{Pres} indicating whether either point corresponds to a presence location or
a quadrature point, and a column \code{wt} of observation weights.}
\author{Ian W. Renner}
\seealso{
\code{\link{sample.quad}} for generating a regular grid of quadrature points.

\code{\link{env.var}} for interpolating environmental data to species presence locations.
}
\examples{
data(BlueMountains)
species.ppm = ppm.dat(sp.xy = BlueMountains$eucalypt, back.xy = BlueMountains$env, 
sp.scale = 1, file.name = "Sp PPM Data")
}
\keyword{Quadrature}
