% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiKHM2015_gov}
\alias{ppiKHM2015_gov}
\title{ppiKHM2015_gov}
\format{A data frame with 9 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100)}
\item{\code{nl150}}{National poverty line (150)}
\item{\code{nl200}}{National poverty line (200)}
\item{\code{median}}{Median poverty line}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiKHM2015_gov
}
\description{
Poverty Probability Index (PPI) lookup table for Cambodia
}
\examples{
  # Access Cambodia PPI table
  ppiKHM2015_gov

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiKHM2015_gov[ppiKHM2015_gov$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiKHM2015_gov, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiKHM2015_gov[ppiKHM2015_gov$score == ppiScore, "nl100"]

}
\keyword{datasets}
