% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppendemic_dat.R
\name{get_ppendemic_data}
\alias{get_ppendemic_data}
\title{Retrieve data for a list of species from the ppendemic_tab dataset.}
\usage{
get_ppendemic_data(splist, max_distance = 0.1)
}
\arguments{
\item{splist}{A character vector containing the names of the species to search for.}

\item{max_distance}{The maximum allowed distance for fuzzy matching of species names.
Defaults to 0.1.}
}
\value{
A data frame containing the retrieved information for each species.
}
\description{
This function takes a list of species names, searches for their data in the
ppendemic_tab dataset, and returns a data frame containing the relevant
information for each species.
}
\examples{

get_ppendemic_data(splist = c("Aa aurantiaca", "Aa aurantiaaia", "werneria nubigena"))

}
