% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{postPP}
\alias{postPP}
\title{Posterior density of effect size and power parameter}
\usage{
postPP(theta, alpha, tr, sr, to, so, x = 1, y = 1, m = 0, v = Inf, ...)
}
\arguments{
\item{theta}{Effect size. Has to be of length one or the same length as
\code{alpha}.}

\item{alpha}{Power parameter. Has to be of length one or the same length as
\code{theta}.}

\item{tr}{Effect estimate of the replication study.}

\item{sr}{Standard error of the replication effect estimate.}

\item{to}{Effect estimate of the original study.}

\item{so}{Standard error of the replication effect estimate.}

\item{x}{Number of successes parameter of beta prior for \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{y}{Number of failures parameter of beta prior for \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{m}{Mean parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{0}.}

\item{v}{Variance parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{Inf} (uniform prior).}

\item{...}{Additional arguments passed to \code{stats::integrate}.}
}
\value{
Posterior density
}
\description{
This function computes the posterior density of effect size
    \eqn{\theta}{theta} and power parameter \eqn{\alpha}{alpha} assuming a
    normal likelihood for original and replication effect estimate. A power
    prior for \eqn{\theta}{theta} is constructed by updating an initial
    normal prior \eqn{\theta \sim \mathrm{N}(\code{m}, \code{v})}{theta ~
    N(m, v)} with the likelihood of the original data raised to the power of
    \eqn{\alpha}{alpha}. A marginal beta prior \eqn{\alpha \sim
    \mbox{Beta}(\code{x},\code{y})}{alpha ~ Beta(x, y)} is assumed.
}
\examples{
alpha <- seq(0, 1, length.out = 200)
theta <- seq(0, 0.3, length.out = 200)
parGrid <- expand.grid(alpha = alpha, theta = theta)
postdens <- postPP(theta = parGrid$theta, alpha = parGrid$alpha, tr = 0.1,
                   sr = 0.05, to = 0.2, so = 0.05)
postdensMat <- matrix(data = postdens, ncol = 200, byrow = TRUE)
filled.contour(x = theta, y = alpha, z = postdensMat,
               xlab = bquote("Effect size" ~ theta),
               ylab = bquote("Power parameter" ~ alpha), nlevels = 15,
               color.palette = function(n) hcl.colors(n = n, palette = "viridis"))
}
\seealso{
\code{\link{postPPalpha}}, \code{\link{postPPtheta}}, \code{\link{plotPP}}
}
\author{
Samuel Pawel
}
