% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova2way.F.bal.R
\name{anova2way.F.bal}
\alias{anova2way.F.bal}
\title{Power calculation for two-way balanced analysis of variance F tests}
\usage{
anova2way.F.bal(
  n = NULL,
  mmatrix = NULL,
  sd = 1,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{n}{The sample size per cell}

\item{mmatrix}{A matrix of cell means (see example).}

\item{sd}{The estimated standard deviation within each cell; defaults to 1.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs sample size and power calculations for F tests in a two-way
ANOVA with balanced data (that is, equal cell sizes). For a given
matrix of cell means, computes power or required cell size
for each factor and for their interaction, if an interaction is present.
For unbalanced data (unequal cell sizes),
see anova2way.F.unbal.
}
\examples{
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.9), nrow = 2, byrow = TRUE)
anova2way.F.bal(n = 30, mmatrix = mmatrix, sd = 2, alpha = 0.05)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.3), nrow = 2, byrow = TRUE)
anova2way.F.bal(n = 30, mmatrix = mmatrix, sd = 2, alpha = 0.05)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.9), nrow = 2, byrow = TRUE)
anova2way.F.bal(n = 30, mmatrix = mmatrix, sd = 2, Rsq = 0.4, ncov = 1, alpha = 0.05)
}
