% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power4test_by_n.R
\name{power4test_by_n}
\alias{power4test_by_n}
\alias{c.power4test_by_n}
\alias{as.power4test_by_n}
\alias{print.power4test_by_n}
\title{Power By Sample Sizes}
\usage{
power4test_by_n(
  object,
  n = NULL,
  progress = TRUE,
  ...,
  by_seed = NULL,
  by_nrep = NULL,
  save_sim_all = TRUE
)

\method{c}{power4test_by_n}(..., sort = TRUE, skip_checking_models = FALSE)

as.power4test_by_n(original_object)

\method{print}{power4test_by_n}(x, print_all = FALSE, ...)
}
\arguments{
\item{object}{A \code{power4test} object,
or a \code{power4test_by_n} object.
If it is a \code{power4test_by_n} object,
the first element, which is a
\code{power4test} object, will be used
as the value of this argument.}

\item{n}{A numeric vector of sample
sizes for which the simulation will
be conducted.}

\item{progress}{Logical. Whether
progress of the simulation will be
displayed.}

\item{...}{For \code{\link[=power4test_by_n]{power4test_by_n()}},
they are arguments to be passed
to \code{\link[=power4test]{power4test()}}. For \code{\link[=c.power4test_by_n]{c.power4test_by_n()}},
they are \code{\link[=power4test_by_n]{power4test_by_n()}} outputs
to be combined together.
For the \code{print} method of the output
of \code{\link[=power4test_by_n]{power4test_by_n()}}, they are
arguments to be passed to the
\code{print} method of the output of
\code{\link[=power4test]{power4test()}} (\code{\link[=print.power4test]{print.power4test()}}).}

\item{by_seed}{If set to a number,
it will be used to generate the
seeds for each call to \code{\link[=power4test]{power4test()}}.
If \code{NULL}, the default, then seeds
will still be randomly generated but
the results cannot be easily reproduced.}

\item{by_nrep}{If set to a number,
it will be used to generate the
number of replications (\code{nrep}) for
each call to \code{\link[=power4test]{power4test()}}.
If set to a numeric vector of the
same length as \code{n}, then these are
the \code{nrep} values for each of the
calls, allowing for different numbers
of replications for the sample sizes.
If \code{NULL}, the default, then the
original \code{nrep} will be used.
This argument is used by
\code{\link[=x_from_power]{x_from_power()}} for efficiency, and
is rarely used when calling
this function directly.}

\item{save_sim_all}{If \code{FALSE},
the dataset in the
\code{power4test} objects are not saved,
to reduce
the size of the output. Default
is \code{TRUE}.}

\item{sort}{When combining the
objects, whether they will be sorted
by sample sizes. Default is \code{TRUE}.}

\item{skip_checking_models}{Whether
the check of the data generation model
will be checked. Default is \code{TRUE}.
Should be set to \code{FALSE} only when
users are certain the they are based
on the same model, or when the model
is not saved (e.g., \code{save_sim_all}
set to \code{FALSE} when the objects
were generated).
This argument is used by
\code{\link[=x_from_power]{x_from_power()}} for efficiency, and
is rarely used when calling
the \code{c} method directly.}

\item{original_object}{The object
to be converted to a \code{power4test_by_n}
object.}

\item{x}{The object
to be printed.}

\item{print_all}{If \code{TRUE}, all
elements in \code{x}, that is, the results
of all sample sizes examined, will
be printed. If \code{FALSE}, then only
those of the first sample size
will be printed.}
}
\value{
The function
\code{\link[=power4test_by_n]{power4test_by_n()}} returns a
\code{power4test_by_n} object, which is a
list of \code{power4test} objects, one for
each sample size.

The method \code{\link[=c.power4test_by_n]{c.power4test_by_n()}} returns
a \code{power4test_by_n} object with
all the elements (tests for different
sample sizes) combined.

The function \code{\link[=as.power4test_by_n]{as.power4test_by_n()}} returns
a \code{power4test_by_n} object converted
from the input object.

The \code{print}-method of \code{power4test_by_n}
objects returns the object invisibly.
It is called for its side-effect.
}
\description{
Estimate power for a
set of sample sizes.
}
\details{
The function \code{\link[=power4test_by_n]{power4test_by_n()}}
regenerates
datasets for a set of sample sizes
and does the stored tests in each of
them.

Optionally, it can also be run
on a object with no stored tests.
In this case, additional arguments
must be set to instruct \code{\link[=power4test]{power4test()}}
on the tests to be conducted.

It is usually used to examine the
power over a set of sample sizes.

The \code{c} method of \code{power4test_by_n}
objects
is used to combine tests from different
runs of \code{\link[=power4test_by_n]{power4test_by_n()}}.

The function \code{\link[=as.power4test_by_n]{as.power4test_by_n()}}
is used to convert a \code{power4test}
object to a \code{power4test_by_n}
object, if it is not already one.
Useful when concatenating
\code{power4test} objects with
\code{power4test_by_n} objects.
}
\examples{

# Specify the model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the population values

model_simple_med_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

sim_only <- power4test(nrep = 2,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 100,
                       R = 40,
                       ci_type = "boot",
                       fit_model_args = list(fit_function = "lm"),
                       do_the_test = FALSE,
                       iseed = 1234)

test_out <- power4test(object = sim_only,
                       test_fun = test_indirect_effect,
                       test_args = list(x = "x",
                                        m = "m",
                                        y = "y",
                                        boot_ci = TRUE,
                                        mc_ci = FALSE))

out <- power4test_by_n(test_out,
                       n = c(100, 110, 120))
out_reject <- rejection_rates(out)
out_reject

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
