% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_library.R
\name{powdRlib}
\alias{powdRlib}
\title{Create an XRPD reference library}
\usage{
powdRlib(xrd_table, phases_table)
}
\arguments{
\item{xrd_table}{A data frame of the count intensities of the XRPD reference patterns,
all scaled to same maximum intensity, with their 2theta axis as the first column.}

\item{phases_table}{A data frame of the required data (phase ID, phase name, and reference
intensity ratio) for each reference pattern.}
}
\value{
a list with components:
\item{xrd}{a data frame of reference patterns}
\item{tth}{a vector of the 2theta axis}
\item{phases}{a 3 column data frame of the IDs, names and reference
intensity ratios of the reference pattern}
}
\description{
A constructor function for creating a \code{powdRlib} object from two tables of
data. The resulting \code{powdRlib} object is required when
using \code{\link{fps}} or \code{\link{afps}}.
}
\examples{
#load an example xrd_table
data(minerals_xrd)
#load an example phases_table
data(minerals_phases)

#Create a reference library object
xrd_lib <- powdRlib(xrd_table = minerals_xrd,
                    phases_table = minerals_phases)
}
