% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/povcalnet.R
\name{povcalnet}
\alias{povcalnet}
\title{povcalnet
Facilitate interaction with the PovcalNet API}
\usage{
povcalnet(
  country = "all",
  povline = 1.9,
  year = "all",
  aggregate = FALSE,
  fill_gaps = FALSE,
  coverage = "all",
  ppp = NULL,
  url = "http://iresearch.worldbank.org",
  format = "csv"
)
}
\arguments{
\item{country}{character: list of country iso3 code (accepts multiple) or
`all`. Use \code{\link{povcalnet_info}} for full list of countries.}

\item{povline}{numeric: poverty line (in 2011 PPP-adjusted USD) to
calculate poverty measures}

\item{year}{numeric:  list of years, or `all`.}

\item{aggregate}{logical: `TRUE` will return aggregate results,
`FALSE` country-level results.}

\item{fill_gaps}{logical: `TRUE` will interpolate / extrapolate values when
surveys are not available for a specific year.}

\item{coverage}{character: Can take one of three values: `national`, `urban`, `rural`}

\item{ppp}{numeric: Optional - Allows the selection of custom PPP (Purchasing Power Parity) exchange rates}

\item{url}{character: API root URL. For testing purposes only, should not be
changed for 99 percent of users.}

\item{format}{character: Response format to be requested from the API:
`csv` or `json`}
}
\value{
data.frame
}
\description{
povcalnet
Facilitate interaction with the PovcalNet API
}
\examples{
\donttest{
povcalnet(country = "ALB")
}

}
