% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/part0_maincall.R
\name{afterggir}
\alias{afterggir}
\title{Main Call for Data Processing after Runing GGIR for Accelerometer Data}
\usage{
afterggir(
  mode,
  useIDs.FN = NULL,
  currentdir,
  studyname,
  bindir = NULL,
  outputdir,
  epochIn = 5,
  epochOut = 5,
  flag.epochOut = 60,
  log.multiplier = 9250,
  use.cluster = TRUE,
  QCdays.alpha = 7,
  QChours.alpha = 16,
  QCnights.feature.alpha = c(0, 0),
  Rversion = "R",
  filename2id = NULL,
  PA.threshold = c(50, 100, 400),
  desiredtz = "US/Eastern",
  RemoveDaySleeper = FALSE,
  trace = FALSE
)
}
\arguments{
\item{mode}{\code{number} Specify which of the five parts need to be run, e.g. mode = 0 makes that all R/Rmd/sh files are generated for other parts. When mode = 1, all csv files in the GGIR output directory were read, transformed and then merged. When mode = 2, the GGIR output files were checked and summarized in one excel sheet. When mode = 3, the merged data was cleaned according to the number of valid hours on each night and the number of valid days for each subject. When mode = 4, the cleaned data was imputed.}

\item{useIDs.FN}{\code{character} Filename with or without directory for sample information in CSV format, which including "filename" and "duplicate" in the headlines at least. If duplicate="remove",  the accelerometer files will not be used in the data analysis of part 5-7. Defaut is NULL, which makes all accelerometer files will be used in part 5-7.}

\item{currentdir}{\code{character} Directory where the output needs to be stored. Note that this directory must exist.}

\item{studyname}{\code{character} Specify the study name that used in the output file names}

\item{bindir}{\code{character} Directory where the accelerometer files are stored or list}

\item{outputdir}{\code{character} Directory where the GGIR output was stored.}

\item{epochIn}{\code{number}  Epoch size to which acceleration was averaged (seconds) in GGIR output. Defaut is 5 seconds.}

\item{epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in part1. Defaut is 5 seconds.}

\item{flag.epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in part 3. Defaut is 60 seconds.}

\item{log.multiplier}{\code{number} The coefficient used in the log transformation of the ENMO data, i.e. log( log.multiplier * ENMO + 1), which have been used in part 5-7. Defaut is 9250.}

\item{use.cluster}{\code{logical}  Specify if part1 will be done by parallel computing. Default is TRUE, and the CSV file in GGIR output will be merged for every 20 files first, and then combined for all.}

\item{QCdays.alpha}{\code{number}  Minimum required number of valid days in subject specific analysis as a quality control step in part2. Default is 7 days.}

\item{QChours.alpha}{\code{number}  Minimum required number of valid hours in day specific analysis as a quality control step in part2. Default is 16 hours.}

\item{QCnights.feature.alpha}{\code{number}  Minimum required number of valid nights in day specific mean and SD analysis as a quality control step in the JIVE analysis. Default is  c(0,0), i.e. no additional data cleaning in this step.}

\item{Rversion}{\code{character}  R version, eg. "R/3.6.3". Default is "R".}

\item{filename2id}{\code{R function}  User defined function for converting filename to sample IDs. Default is NULL.}

\item{PA.threshold}{\code{number}  Threshold for light, moderate and vigorous physical activity. Default is c(50,100,400).}

\item{desiredtz}{\code{charcter}  desired timezone: see also http://en.wikipedia.org/wiki/Zone.tab. Used in g.inspectfile(). Default is "US/Eastern".}

\item{RemoveDaySleeper}{\code{logical}  Specify if the daysleeper nights are removed from the calculation of number of valid days for each subject. Default is FALSE.}

\item{trace}{\code{logical}  Specify if the intermediate results is printed when the function was executed. Default is FALSE.}
}
\value{
See postGGIR manual for details.
}
\description{
This R script will generate all necessary R/Rmd/shell files for data processing after running GGIR for accelerometer data.
}
