% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLSDominance.R
\name{BLSDominance}
\alias{BLSDominance}
\title{Computing the BLS dominance matrix of a poset.}
\usage{
BLSDominance(poset)
}
\arguments{
\item{poset}{Object of S4 class \code{POSet} (the input poset).
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
The BLS dominance matrix
}
\description{
Computes the dominance matrix of the input poset, based on the BLS formula of Brueggemann et al. (2003).
}
\examples{

el <- c("a", "b", "c", "d")
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)
pos <- POSet(elements = el, dom = dom)

res <- BLSDominance(pos)


}
\references{
Brueggemann R., Lerche D. B., Sørensen P. B. (2003). First attempts to relate structures of
Hasse diagrams with mutual probabilities, in: Sørensen P.B., Brueggemann R., Lerche D.B.,
Voigt K.,Welzl G., Simon U., Abs M., Erfmann M., Carlsen L., Gyldenkærne S., Thomsen M.,
Fauser P., Mogensen B. B., Pudenz S., Kronvang B. Order Theory in Environmental Sciences
Integrative approaches.The 5th workshop held at the National Environmental Research Institute
(NERI), Roskilde, Denmark, November 2002. National Environmental Research Institute,
Denmark - NERI Technical Report, No. 479.
}
