% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsDownset.R
\name{IsDownset}
\alias{IsDownset}
\title{Checking for downsets.}
\usage{
IsDownset(poset, elements)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{elements}{A vector of character strings (the names of the input) elements).}
}
\value{
A boolean value.
}
\description{
Checks whether the input elements form a downset, in the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

chk <- IsDownset(pos, c("a", "b", "c"))

}
