% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{set_age_open}
\alias{set_age_open}
\title{Specify Open Age Group}
\usage{
set_age_open(x, lower)
}
\arguments{
\item{x}{A vector of age labels.}

\item{lower}{An integer. The lower limit
for the open age group.}
}
\value{
A modified version of \code{x}.
}
\description{
Set the lower limit of the open age group.
Given a vector of age group labels,
recode all age groups with a lower limit
greater than or equal to \verb{<lower>} to \verb{<lower>+}.
}
\details{
\code{set_age_open()} requires that \code{x} and
the return value have a
a five-year, single-year, or life table format,
as described in \code{\link[=age_labels]{age_labels()}}.
}
\examples{
x <- c("100+", "80-84", "95-99", "20-24")
set_age_open(x, 90)
set_age_open(x, 25)
}
\seealso{
\itemize{
\item \code{set_age_open()} uses \code{\link[=age_lower]{age_lower()}} to identify
lower limits
\item \code{\link[=age_labels]{age_labels()}} for creating age labels from scratch
}
}
