% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.r
\name{poppr.plot}
\alias{poppr.plot}
\title{Internal function to plot the results from ia() and poppr()}
\usage{
poppr.plot(sample, pval = c(Ia = 0.05, rbarD = 0.05), pop = NULL,
  file = NULL, N = NULL, observed = c(Ia = 0, rbarD = 0),
  index = c("rbarD", "Ia"), labsize = rel(3), linesize = rel(1))
}
\arguments{
\item{sample}{either an object of class "ialist" or a list of ialists}

\item{pval}{a named vector specifying the p values to display}

\item{pop}{The name of the population}

\item{file}{The name of the source file}

\item{N}{The number of samples in the population}

\item{observed}{observed values of Ia and rbarD}

\item{index}{The index to plot (defaults to "rbarD")}

\item{labsize}{size of the in-plot label}

\item{linesize}{size of the in-plot line}
}
\value{
a ggplot2 object
}
\description{
Internal function to plot the results from ia() and poppr()
}
\examples{
\dontrun{
data(Pinf)
x <- Pinf \%>\% seppop() \%>\% lapply(ia, sample = 99, valuereturn = TRUE, quiet = TRUE, plot = FALSE)
x
poppr:::poppr.plot(sample = x, file = "hey") # plots multiple populations
# plot.ialist takes care of the single populations.
for (i in x){
  print(plot(i))
}
}

}
\keyword{internal}
