% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{plot.survtab}
\alias{plot.survtab}
\title{\code{plot} method for survtab objects}
\usage{
\method{plot}{survtab}(x, y = NULL, subset = NULL, conf.int = TRUE,
  col = NULL, lty = NULL, ylab = NULL, xlab = NULL, ...)
}
\arguments{
\item{x}{a \code{survtab} output object}

\item{y}{survival a character vector of a variable names to plot;
e.g. \code{y = "r.e2"}}

\item{subset}{a logical condition; \code{obj} is subset accordingly 
before plotting; use this for limiting to specific strata, 
e.g. \code{subset = sex == "male"}}

\item{conf.int}{logical; if \code{TRUE}, also plots any confidence intervals
present in \code{obj} for variables in \code{y}}

\item{col}{line colour; one value for each stratum; will be recycled}

\item{lty}{line type; one value for each stratum; will be recycled}

\item{ylab}{label for Y-axis}

\item{xlab}{label for X-axis}

\item{...}{additional arguments passed on to \code{plot} and 
\code{lines.survtab}; e.g. \code{ylim} can be defined this way}
}
\description{
Plotting for \code{survtab} objects
}
\examples{
data(sire)
data(sibr)
si <- rbind(sire, sibr)
si$period <- cut(si$dg_date, as.Date(c("1993-01-01", "2004-01-01", "2013-01-01")), right = FALSE)
si$cancer <- c(rep("rectal", nrow(sire)), rep("breast", nrow(sibr)))
x <- lexpand(si, birth = bi_date, entry = dg_date, exit = ex_date, 
             status = status \%in\% 1:2, 
             fot = 0:5, aggre = list(cancer, period, fot))
st <- survtab_ag(fot ~ cancer + period, data = x, 
                 surv.method = "lifetable", surv.type = "surv.obs")

plot(st, "surv.obs", subset = cancer == "breast", ylim = c(0.5, 1), col = "blue")
lines(st, "surv.obs", subset = cancer == "rectal", col = "red")

## or
plot(st, "surv.obs", col = c(2,2,4,4), lty = c(1, 2, 1, 2))
}
\seealso{
Other survtab functions: \code{\link{lines.survtab}},
  \code{\link{print.survtab}},
  \code{\link{summary.survtab}}, \code{\link{survtab_ag}},
  \code{\link{survtab}}
}
\author{
Joonas Miettinen
}
\concept{survtab functions}
