% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_components.R
\name{basic components}
\alias{basic components}
\title{Basic POMP model components.}
\description{
Mathematically, the parts of a \acronym{POMP} model include the latent-state process transition distribution, the measurement-process distribution, the initial-state distribution, and possibly a prior parameter distribution.
Algorithmically, each of these corresponds to at least two distinct operations.
In particular, for each of the above parts, one sometimes needs to make a random draw from the distribution and sometimes to evaluate the density function.
Accordingly, for each such component, there are two basic model components, one prefixed by a \sQuote{r}, the other by a \sQuote{d}, following the usual \R convention.
}
\details{
In addition to the parts listed above, \pkg{pomp} includes two additional basic model components: the deterministic skeleton, and parameter transformations that can be used to map the parameter space onto a Euclidean space for estimation purposes.

There are thus altogether nine \bold{basic model components}:
\enumerate{
\item \link[=rprocess specification]{rprocess}, which samples from the latent-state transition distribution,
\item \link[=dprocess specification]{dprocess}, which evaluates the latent-state transition density,
\item \link[=rmeasure specification]{rmeasure}, which samples from the measurement distribution,
\item \link[=dmeasure specification]{dmeasure}, which evaluates the measurement density,
\item \link[=prior specification]{rprior}, which samples from the prior distribution,
\item \link[=prior specification]{dprior}, which evaluates the prior density,
\item \link[=rinit specification]{rinit}, which samples from the initial-state distribution,
\item \link[=skeleton specification]{skeleton}, which evaluates the deterministic skeleton,
\item \link[=parameter_trans]{partrans}, which evaluates the forward or inverse parameter transformations.
}

Each of these can be set or modified in the \code{pomp} constructor function or in any of the \pkg{pomp} \link[=elementary algorithms]{elementary algorithms} or \link[=estimation algorithms]{estimation algorithms} using an argument that matches the basic model component.
A basic model component can be unset by passing \code{NULL} in the same way.

Help pages detailing each basic model component are provided.
}
\seealso{
\link[=workhorses]{workhorse functions},
\link[=elementary algorithms]{elementary algorithms},
\link[=estimation algorithms]{estimation algorithms}.

More on implementing POMP models: 
\code{\link{Csnippet}},
\code{\link{accumulator variables}},
\code{\link{covariates}},
\code{\link{distributions}},
\code{\link{dmeasure specification}},
\code{\link{dprocess specification}},
\code{\link{parameter transformations}},
\code{\link{pomp-package}},
\code{\link{pomp}},
\code{\link{prior specification}},
\code{\link{rinit specification}},
\code{\link{rmeasure specification}},
\code{\link{rprocess specification}},
\code{\link{skeleton specification}},
\code{\link{transformations}},
\code{\link{userdata}}
}
\concept{basic model components}
\concept{implementation information}
