% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{PVE}
\alias{PVE}
\title{Function to determine the percentage variance explained (PVE) of a (maximal) QTL model, and explore sub-models.}
\usage{
PVE(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  block = NULL,
  QTL_df = NULL,
  folder = NULL,
  filename.short,
  prop_Pheno_rep = 0.5,
  log = NULL,
  verbose = FALSE
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the offspring identifiers (F1 names)}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model}

\item{block}{The blocking factor to be used, if any (must be colname of \code{Phenotype.df}). By default \code{NULL}, in 
which case no blocking structure (for unreplicated experiments)}

\item{QTL_df}{A 3-column data frame of previously detected QTLs containing the following columns: column 1 gives linkage 
group identifiers, column 2 specifies the fitted QTL type, i.e. whether the fitted QTL is a "marker" or "position",
and column 3 gives the marker/position IDs of the fitted QTL. If not specified, an error results.}

\item{folder}{If markers are to be used as fitted QTL and TetraOrigin was used for IBD estimation, the path to the folder 
in which the imported IBD probabilities is contained can be provided here. By default this is \code{NULL}, if files are in working directory.}

\item{filename.short}{If a fitted QTL is a specific marker and TetraOrign was used for IBD estimation, the shortened stem of the filename
of the \code{.csv} files containing the output of TetraOrigin, i.e. without the tail "_LinkageGroupX_Summary.csv" which is 
added by default to all output of TetraOrigin.}

\item{prop_Pheno_rep}{The minimum proportion of phenotypes represented across blocks. If less than this, the individual is 
removed from the analysis. If there is incomplete data, the missing phenotypes are imputed using the mean values across the recorded observations.}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}

\item{verbose}{Should messages be written to standard output?}
}
\value{
A list with percentage variance explained of maximal QTL model and all sub-models
}
\description{
This function builds a (maximal) QTL model from previously detected QTL peaks and outputs the percentage variance explained (PVE)
of the full QTL model and all sub-models. It uses a similar approach to the fitting of genetic co-factors in the function \code{\link{QTLscan}}.
The PVE is very similar to but not exactly equal to the adjusted R2 returned in \code{QTLscan} at each position (and note: in the former case, these
R2 values are per-locus, while this function can estimate the PVE combined over multiple loci). The discrepancy has to do with how PVE is calculated 
using the formula 100(1 - RSS0/RSS1), where RSS0 and RSS1 are the residual sums of squares of the NULL and QTL models, respectively.
}
\examples{
data("IBD_4x","Phenotypes_4x")
PVE(IBD_list = IBD_4x,
    Phenotype.df = Phenotypes_4x,
    genotype.ID = "geno",trait.ID = "pheno",
    block = "year",
    QTL_df = data.frame(LG=1,type="position",id=12.3))
}
