% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.SV.R
\name{polygauss}
\alias{polygauss}
\title{Calculate 2D Nodes and Weights of the Product Gauss Cubature}
\usage{
polygauss(xy, nw_MN, alpha = NULL, rotation = FALSE, engine = "C")
}
\arguments{
\item{xy}{list with elements \code{"x"} and \code{"y"} containing the
polygon vertices in \emph{anticlockwise} order (otherwise the result of the
cubature will have a negative sign) with first vertex not repeated at the
end (like \code{owin.object$bdry}).}

\item{nw_MN}{unnamed list of nodes and weights of one-dimensional Gauss
quadrature rules of degrees \eqn{N} and \eqn{M=N+1} (as returned by
\code{\link[statmod]{gauss.quad}}): \code{list(s_M, w_M, s_N, w_N)}.}

\item{alpha}{base-line of the (rotated) polygon at \eqn{x = \alpha} (see
Sommariva and Vianello (2007) for an explication). If \code{NULL} (default),
the midpoint of the x-range of each polygon is chosen if no \code{rotation}
is performed, and otherwise the \eqn{x}-coordinate of the rotated point
\code{"P"} (see \code{rotation}). If \code{f} has its maximum value at the
origin \eqn{(0,0)}, e.g., the bivariate Gaussian density with zero mean,
\code{alpha = 0} is a reasonable choice.}

\item{rotation}{logical (default: \code{FALSE}) or a list of points
\code{"P"} and \code{"Q"} describing the preferred direction. If
\code{TRUE}, the polygon is rotated according to the vertices \code{"P"} and
\code{"Q"}, which are farthest apart (see Sommariva and Vianello, 2007). For
convex polygons, this rotation guarantees that all nodes fall inside the
polygon.}

\item{engine}{character string specifying the implementation to use.
Up to \pkg{polyCub} version 0.4-3, the two-dimensional nodes and weights 
were computed by \R functions and these are still available by setting
\code{engine = "R"}.
The new C-implementation is now the default (\code{engine = "C"}) and 
requires approximately 30\% less computation time.\cr
The special setting \code{engine = "C+reduce"} will discard redundant nodes
at (0,0) with zero weight resulting from edges on the base-line
\eqn{x = \alpha} or orthogonal to it. 
This extra cleaning is only worth its cost for computationally intensive
functions \code{f} over polygons which really have some edges on the
baseline or parallel to the x-axis.  Note that the old \R
implementation does not have such unset zero nodes and weights.}
}
\description{
Calculate 2D Nodes and Weights of the Product Gauss Cubature
}
\references{
Sommariva, A. and Vianello, M. (2007):
Product Gauss cubature over polygons based on Green's integration formula.
\emph{Bit Numerical Mathematics}, \bold{47} (2), 441-453.
}
\keyword{internal}
