% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\docType{methods}
\name{dispersion}
\alias{dispersion}
\alias{dispersion,partition-method}
\alias{dispersion,slice-method}
\alias{dispersion,subcorpus-method}
\alias{dispersion,corpus-method}
\alias{dispersion,character-method}
\alias{dispersion,hits-method}
\title{Dispersion of a query or multiple queries.}
\usage{
dispersion(.Object, ...)

\S4method{dispersion}{slice}(.Object, query, s_attribute, cqp = FALSE,
  p_attribute = getOption("polmineR.p_attribute"), freq = FALSE,
  mc = FALSE, progress = FALSE, verbose = FALSE, ...)

\S4method{dispersion}{partition}(.Object, query, s_attribute,
  cqp = FALSE, p_attribute = getOption("polmineR.p_attribute"),
  freq = FALSE, mc = FALSE, progress = TRUE, verbose = FALSE, ...)

\S4method{dispersion}{subcorpus}(.Object, query, s_attribute,
  cqp = FALSE, p_attribute = getOption("polmineR.p_attribute"),
  freq = FALSE, mc = FALSE, progress = TRUE, verbose = FALSE, ...)

\S4method{dispersion}{corpus}(.Object, query, s_attribute, cqp = is.cqp,
  p_attribute = getOption("polmineR.p_attribute"), freq = FALSE,
  mc = FALSE, progress = FALSE, verbose = FALSE, ...)

\S4method{dispersion}{character}(.Object, query, s_attribute,
  cqp = is.cqp, p_attribute = getOption("polmineR.p_attribute"),
  freq = FALSE, mc = FALSE, progress = TRUE, verbose = TRUE, ...)

\S4method{dispersion}{hits}(.Object, source, s_attribute, freq = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{.Object}{A \code{partition} object or a corpus provided by a character
string.}

\item{...}{Further parameters.}

\item{query}{A \code{character} vector stating one or multiple queries.}

\item{s_attribute}{A \code{character} vector (length 1 or 2) providing s-attributes.}

\item{cqp}{If \code{logical}, whether the query is a CQP query, if it is a
function that is passed in, the function will be applied to the query to
guess whether query is a CQP query}

\item{p_attribute}{Length one \code{character} vector, the p-attribute that
will be looked up (typically 'word' or 'lemma').}

\item{freq}{A \code{logical} value, whether to calculate normalized frequencies.}

\item{mc}{A \code{logical} value, whether to use multicore.}

\item{progress}{A \code{logical} value, whether to show progress.}

\item{verbose}{A \code{logical} value, whether to be verbose.}

\item{source}{The source of the evaluation the hits reported in
\code{.Object} are based on, a \code{corpus}, \code{subcorpus} or
\code{partition} object.}
}
\value{
depends on the input, as this is a wrapper function

A \code{data.table}.
}
\description{
The method returns counts (optionally frequencies) of a query or a multiple
queries in subcorpora defined by one or two s-attributes.
}
\examples{
use("polmineR")
dispersion("GERMAPARLMINI", query = "Integration", s_attribute = "date")

test <- partition("GERMAPARLMINI", date = ".*", p_attribute = NULL, regex = TRUE)
integration <- dispersion(
  test, query = "Integration",
  p_attribute = "word", s_attribute = "date"
)
integration <- dispersion(test, "Integration", s_attribute = c("date", "party"))
integration <- dispersion(test, '"Integration.*"', s_attribute = "date", cqp = TRUE)
}
\seealso{
The worker behind the \code{dispersion}-method is the \code{hits}-method.

count
}
\author{
Andreas Blaette
}
