% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_method.R
\docType{methods}
\name{encode}
\alias{encode}
\alias{encode,data.frame-method}
\alias{encode,data.table-method}
\alias{encode,regions-method}
\alias{encode,character-method}
\title{Encode s-attribute or corpus.}
\usage{
encode(.Object, ...)

\S4method{encode}{data.frame}(.Object, name, pAttributes = "word",
  sAttributes = NULL, registry = Sys.getenv("CORPUS_REGISTRY"),
  dataDir = NULL, verbose = TRUE)

\S4method{encode}{data.table}(.Object, corpus, sAttribute, verbose = TRUE)

\S4method{encode}{regions}(.Object, sAttribute, values, verbose = TRUE)

\S4method{encode}{character}(.Object, corpus, pAttribute = NULL,
  dataDir = NULL, verbose = TRUE)
}
\arguments{
\item{.Object}{a \code{data.frame} to encode}

\item{...}{further parameters}

\item{name}{name of the (new) CWB corpus}

\item{pAttributes}{columns of .Object with tokens (such as word/pos/lemma)}

\item{sAttributes}{columns of .Object that will be encoded as structural attributes}

\item{registry}{path to the corpus registry}

\item{dataDir}{data directory for indexed corpus files}

\item{verbose}{logical, whether to be verbose}

\item{corpus}{the name of the CWB corpus}

\item{sAttribute}{a single s-attribute}

\item{values}{values for regions}

\item{pAttribute}{a single p-attribute}
}
\description{
If \code{.Object} is a \code{data.frame}, it needs to have a column with the token
stream (column name 'word'), and further columns with either p-attributes,
or s-attributes. The corpus will be encoded successively, starting with the
p-attributes.
}
\details{
If \code{.Object} is a \code{data.table}, it is assumed to have three columns: The
left corpus position, the right corpus position and the value of a s-attribute
that will be encoded. The method is used to add s-attributes to a corpus.

If \code{.Object} is a (character) \code{vector}, there are two usages. If the corpus
defined by the parameter \code{corpus} does not yet exist, the vector is taken as
the word token stream. A new registry file, and a new data directory will be generated.  If
the \code{corpus} already exists, a new p-attribute will be added to the pre-existing
corpus.
}
\examples{
\donttest{
library(tm)
reut21578 <- system.file("texts", "crude", package = "tm")
reuters.tm <- VCorpus(DirSource(reut21578), list(reader = readReut21578XMLasPlain))

library(tidytext)
reuters.tibble <- tidy(reuters.tm)
reuters.tibble[["topics_cat"]] <- sapply(
  reuters.tibble[["topics_cat"]],
  function(x) paste(reuters.tibble[["topics_cat"]], collapse = "|")
)
reuters.tibble[["places"]] <- sapply(
  reuters.tibble[["places"]],
  function(x) paste(x, collapse = "|")
)
reuters.tidy <- unnest_tokens(
  reuters.tibble, output = "word", input = "text", to_lower = FALSE
)
encode(
  reuters.tidy, name = "reuters2",
  sAttributes = c("language", "places")
)
}
}
