% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_method.R
\docType{methods}
\name{read}
\alias{read}
\alias{read,data.table-method}
\alias{read,hits-method}
\alias{read,kwic-method}
\alias{read,partition-method}
\alias{read,partitionBundle-method}
\title{Return to the original text and read}
\usage{
read(.Object, ...)

\S4method{read}{partition}(.Object, meta = getOption("polmineR.meta"),
  highlight = list(), cqp = FALSE, tooltips = NULL, verbose = TRUE,
  cpos = FALSE, ...)

\S4method{read}{partitionBundle}(.Object, highlight = list(), cqp = FALSE,
  cpos = FALSE, ...)

\S4method{read}{data.table}(.Object, col, partitionBundle, cqp = FALSE,
  highlight = list(), cpos = FALSE, ...)

\S4method{read}{hits}(.Object, def, i = NULL, ...)

\S4method{read}{kwic}(.Object, i, type = NULL)
}
\arguments{
\item{.Object}{an object to be read (\code{"partition" or "partitionBundle"})}

\item{...}{further parameters passed into read}

\item{meta}{a character vector supplying s-attributes for the metainformation
to be printed, if not stated explicitly, session settings will be used}

\item{highlight}{a list}

\item{cqp}{a list of character vectors with regular expressions to
highlight relevant terms or expressions; the names of the list provide the
colors}

\item{tooltips}{a list}

\item{verbose}{logical}

\item{cpos}{logical}

\item{col}{column}

\item{partitionBundle}{a partitionBundle object}

\item{def}{...}

\item{i}{...}

\item{type}{...}
}
\description{
Generate text (i.e. html) and read it in the viewer pane of RStudio. If called on
a \code{"partitionBundle"}-object, skip through the partitions contained in the
bundle.
}
\examples{
if (require(polmineR.sampleCorpus) && require(rcqp)){
   use("polmineR.sampleCorpus")
   options("polmineR.meta" = "text_date")
   merkel <- partition(
     "PLPRBTTXT",
     text_date="2009-11-10", text_name="Angela Dorothea Merkel",
     type="plpr"
   )
   read(merkel, meta=c("text_name", "text_date"))
   read(
     merkel,
     highlight=list(yellow=c("Deutschland", "Bundesrepublik"), lightgreen="Regierung")
     )
   all <- partition("PLPRBTTXT", list(text_id=".*"), regex=TRUE, type="plpr")
   \dontrun{
   speeches <- as.speeches(all, sAttributeDates="text_date", sAttributeNames="text_name", gap=500)
   read(speeches)
   migVocab <- count(speeches, query=c("Migration", "Integration", "Zuwanderung"))
   read(migVocab, col="Integration", partitionBundle=speeches)
   }
}
}
\seealso{
For concordances / a keword-in-context display, see \code{\link{kwic}}.
}

