% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_functions.R
\name{predict.nuisance_functions}
\alias{predict.nuisance_functions}
\title{Predict g-functions and Q-functions}
\usage{
\method{predict}{nuisance_functions}(object, new_policy_data, ...)
}
\arguments{
\item{object}{Object of class "nuisance_functions". Either \code{g_functions}
or \code{q_functions} as returned by \code{\link[=policy_eval]{policy_eval()}} or \code{\link[=policy_learn]{policy_learn()}}.}

\item{new_policy_data}{Policy data object created by \code{\link[=policy_data]{policy_data()}}.}

\item{...}{Additional arguments passed to lower level functions.}
}
\value{
\link{data.table} with keys \code{id} and \code{stage} and variables \code{g_a} or \code{Q_a} for
each action a in the actions set.
}
\description{
\code{predict()} returns the fitted values of the g-functions and
Q-functions when applied to a (new) policy data object.
}
\examples{
library("polle")
### Single stage:
source(system.file("sim", "single_stage.R", package="polle"))
d1 <- sim_single_stage(5e2, seed=1)
pd1 <- policy_data(d1, action="A", covariates=list("Z", "B", "L"), utility="U")
pd1
# defining a static policy:
pl1 <- policy_def(static_policy(1))

# doubly robust evaluation of the policy:
pe1 <- policy_eval(policy_data = pd1,
            policy = pl1,
            g_models = g_glm(),
            q_models = q_glm())
# summarizing the estimated value of the policy:
pe1

# getting the fitted g-function values:
head(predict(get_g_functions(pe1), pd1))

# getting the fitted Q-function values:
head(predict(get_q_functions(pe1), pd1))
}
