% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-select.R
\name{plotTE}
\alias{plotTE}
\title{Estimated total error plot as in Mathur (2012)}
\usage{
plotTE(
  hgrid,
  etrunc,
  eround,
  hopt = NULL,
  i.increasing = NULL,
  i.good = NULL,
  i.okay = NULL,
  eps = .Machine$double.eps/2,
  delta = .Machine$double.eps/2,
  ...
)
}
\arguments{
\item{hgrid}{Numeric vector: a sequence of step sizes used as the horizontal positions
(usually exponentially spaced).}

\item{etrunc}{Numeric vector: estimated truncation error at each step size.
This is typically computed by subtracting a more accurate finite-difference approximation from
a less accurate one.}

\item{eround}{Numeric vector: estimated rounding error at each step size; usually the best guess
or the upper bound is used.}

\item{hopt}{Numeric scalar (optional): selected optimal step size. If provided,
a vertical line is drawn at this value.}

\item{i.increasing}{Integer vector (optional): indices of step sizes where the
truncation error is increasing, which indicates the search range.}

\item{i.good}{Integer vector (optional): indices of step sizes where the truncation
error follows the expected reduction (slope ~ accuracy order; 2 for central differences).}

\item{i.okay}{Integer vector (optional): indices where the truncation error is
acceptable but slightly deviates from the expected behaviour.}

\item{eps}{Numeric scalar: condition error, i.e. the error bound for the accuracy of the evaluated
function; used for labelling rounding error assumptions.}

\item{delta}{Numeric scalar: subtraction cancellation error, used for labelling rounding error
assumptions.}

\item{...}{Additional graphical parameters passed to \code{plot()}.}
}
\value{
Nothing (invisible null).
}
\description{
Visualises the estimated truncation error, rounding error, and total error
used in automatic step-size selection for numerical differentiation.
The plot follows the approach used in Mathur (2012) and other step-selection methods.
}
\examples{
hgrid <- 10^seq(-8, 3, 0.25)
plotTE(hgrid, etrunc = 2e-12 * hgrid^2 + 1e-14 / hgrid,
       eround = 1e-14 / hgrid, hopt = 0.4, i.increasing = 30:45, i.good = 32:45)
}
