% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_output_nodes.R
\name{make_output_nodes}
\alias{make_output_nodes}
\title{Add Output nodes to a PMML object.}
\usage{
make_output_nodes(name = "OutputField", attributes = NULL,
  expression = NULL, namespace = "4_4")
}
\arguments{
\item{name}{The name of the element to be created.}

\item{attributes}{The node attributes to be added.}

\item{expression}{Post-processing information to be included in the element.
This expression will be processed by \code{function_to_pmml}.}

\item{namespace}{The namespace of the PMML model.}
}
\value{
List of nodes
}
\description{
Add Output nodes to a PMML object.
}
\details{
Create a list of nodes with names \code{'name'}, attributes \code{'attributes'} and
child elements \code{'expression'}. \code{'expression'} is a string converted to XML
similar to \code{function_to_pmml}.

Meant to create OutputField elements, 'expressions' can be used to add
post-processing transformations to a model. To create multiple such nodes,
all the parameters must be given as lists of equal length.
}
\examples{
# Make two nodes, one with attributes
two_nodes <- make_output_nodes(
  name = list("OutputField", "OutputField"),
  attributes = list(list(name = "dbl", optype = "continuous"), NULL),
  expression = list("ln(x)", "ln(x/(1-x))")
)
}
\author{
Tridivesh Jena
}
